/*
 * Decompiled with CFR 0.152.
 */
package net.wetters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Random;
import net.wetters.InetAddressLocatorException;

public class InetAddressLocator {
    public static Locale getLocale(String string) throws InetAddressLocatorException {
        Locale locale;
        try {
            locale = net.sf.javainetlocator.InetAddressLocator.getLocale(string);
        }
        catch (net.sf.javainetlocator.InetAddressLocatorException inetAddressLocatorException) {
            throw new InetAddressLocatorException(inetAddressLocatorException.getMessage(), inetAddressLocatorException);
        }
        return locale;
    }

    public static Locale getLocale(InetAddress inetAddress) throws InetAddressLocatorException {
        Locale locale;
        try {
            locale = net.sf.javainetlocator.InetAddressLocator.getLocale(inetAddress);
        }
        catch (net.sf.javainetlocator.InetAddressLocatorException inetAddressLocatorException) {
            throw new InetAddressLocatorException(inetAddressLocatorException.getMessage(), inetAddressLocatorException);
        }
        return locale;
    }

    public static Locale getLocale(byte[] byArray) throws InetAddressLocatorException {
        Locale locale;
        try {
            locale = net.sf.javainetlocator.InetAddressLocator.getLocale(byArray);
        }
        catch (net.sf.javainetlocator.InetAddressLocatorException inetAddressLocatorException) {
            throw new InetAddressLocatorException(inetAddressLocatorException.getMessage(), inetAddressLocatorException);
        }
        return locale;
    }

    public static void main(String[] stringArray) throws InetAddressLocatorException {
        System.out.println();
        System.out.println("  InetAddressLocator - Java country lookup.");
        System.out.println("  -----------------------------------------");
        System.out.println("  Copyright (c) 2003 Nigel Wetters <nigel@wetters.net>");
        System.out.println("  All Rights Reserved. NO WARRANTY.");
        System.out.println();
        InetAddressLocator.bench();
        InetAddressLocator.console();
    }

    private static void console() {
        String string = null;
        System.out.println("  Locating localhost");
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("  ** resolver error: " + unknownHostException.getMessage());
            System.out.println("  continuing...");
            string = "127.0.0.1";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (string != null && !string.equals("q")) {
            block14: {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(string);
                    System.out.println("    Host: " + inetAddress.toString());
                    try {
                        Locale locale = InetAddressLocator.getLocale(string);
                        if (locale.getCountry().equals("")) {
                            System.out.println("    Country: Unknown");
                            break block14;
                        }
                        if (locale.getCountry().equals("**")) {
                            System.out.println("    Country: Unknown (private network)");
                            break block14;
                        }
                        System.out.println("    Country:  " + locale.getDisplayCountry());
                        System.out.println("    Language: " + locale.getDisplayLanguage());
                    }
                    catch (InetAddressLocatorException inetAddressLocatorException) {
                        System.out.println("    ** " + inetAddressLocatorException.getMessage());
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println("    ** could not find hostname **");
                }
            }
            System.out.println();
            System.out.print("  enter host ('q' to quit) > ");
            try {
                while ((string = bufferedReader.readLine()) != null && string.equals("")) {
                    System.out.print("  enter host ('q' to quit) > ");
                }
            }
            catch (IOException iOException) {
                System.out.println("error reading standard input: " + iOException.getMessage());
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("error closing standard input: " + iOException.getMessage());
        }
        System.out.println();
        System.out.println("  Bye Bye.");
        System.out.println();
    }

    private static void bench() throws InetAddressLocatorException {
        System.out.println("  Running benchmark. Please be patient...");
        InetAddress[] inetAddressArray = new InetAddress[65536];
        Random random = new Random();
        try {
            int n = 0;
            while (n < inetAddressArray.length) {
                inetAddressArray[n] = InetAddress.getByName(random.nextInt(256) + "." + random.nextInt(256) + "." + random.nextInt(256) + "." + random.nextInt(256));
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new InetAddressLocatorException("name resolver error in benchmark", unknownHostException);
        }
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            Locale locale = InetAddressLocator.getLocale(inetAddressArray[n2]);
            if (!locale.getCountry().equals("")) {
                ++n;
            }
            ++n2;
        }
        long l2 = System.currentTimeMillis();
        long l3 = 1L;
        if (l2 > l) {
            l3 = l2 - l;
        }
        int n3 = (int)((long)(inetAddressArray.length * 1000) / l3);
        int n4 = n * 100 / inetAddressArray.length;
        System.out.println("    Speed: " + n3 + " ops/sec");
        System.out.println("           (" + n4 + "% of address space is allocated)");
        System.out.println();
    }
}

