<cfsetting enablecfoutputonly="yes">

<!--- @@Copyright: Daemon Pty Limited 2002-2008, http://www.daemon.com.au --->
<!--- @@License:
    This file is part of FarCry.

    FarCry is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FarCry is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with FarCry.  If not, see <http://www.gnu.org/licenses/>.
--->

<!--------------------------------------------------------------------
Search Results
 - dmInclude (_search.cfm)
--------------------------------------------------------------------->
<!--- @@displayname: Search Results Page --->
<!--- @@author: Geoff Bowers (modius@daemon.com.au) --->


<!--- get active verity collections --->
<cfset lCollections = arrayToList(application.config.verity.aIndices)>

<!--- inbound parameters defaults --->
<cfparam name="form.criteria" default="">
<cfparam name="form.searchOperator" default="">

<!--- check if called from x page in results --->
<cfif isdefined("url.criteria")>
	<cfset form.criteria = url.criteria>
</cfif>
<cfif isdefined("url.searchOperator")>
	<cfset form.searchOperator = url.searchOperator>
</cfif>

<!--- check for verity reserved words --->
<cfif findNoCase("not", trim(form.criteria)) or findNoCase("or", trim(form.criteria)) or findNoCase("and", trim(form.criteria))>
	<cfset form.searchOperator =  "Custom">
</cfif>

<!--- treat search criteria with appropriate Verity operator --->
<cfswitch expression="#form.searchOperator#">
	<cfcase value="ALL"> 
		<cfset SearchCriteria = replacenocase(trim(form.criteria), " ", " AND ", "ALL")>
	</cfcase>
	<cfcase value="Custom">
		<cfset SearchCriteria = trim(form.criteria)>
	</cfcase>
	<cfcase value="PHRASE">
		<cfset SearchCriteria = replacenocase(trim(form.criteria), " ", "<PHRASE>", "ALL")>
	</cfcase>
	<cfdefaultcase> <!--- treat as ANY --->
		<cfscript>
			if (not findNoCase("not", trim(form.criteria))) {
				SearchCriteria = replacenocase(trim(form.criteria), ",", "", "ALL");
				SearchCriteria = replacenocase(trim(form.criteria), " ", " OR ", "ALL");
			}
			else 
				SearchCriteria = trim(form.criteria);
		</cfscript>
	</cfdefaultcase>
</cfswitch>

<!--- get serach results --->
<cfif len(form.criteria)>
	<cfset qResults = application.factory.oVerity.search(lCollections=lCollections,searchString=searchCriteria)>
</cfif>

<cfoutput>

<form action="#application.url.conjurer#?objectid=#application.navid.search#" method="post" style="margin:10px,0,15,30px;">
	<input type="text" name="criteria" id="criteria-advanced" value="#form.criteria#" />
	<select name="searchOperator">
		<option value="ANY"<cfif form.SearchOperator eq "ANY"> selected="selected"</cfif>>Any of these words</option>
	  	<option value="ALL"<cfif form.SearchOperator eq "ALL"> selected="selected"</cfif>>All of these words</option>
	  	<option value="PHRASE"<cfif form.SearchOperator eq "PHRASE"> selected="selected"</cfif>>These words as a phrase</option>
	</select>
	<input type="submit" name="action" id="action" value="Search" class="searchSubmit" />
</form>
</cfoutput>

<cfparam name="url.startrow" default="1">
<cfset maxrows = 10>

<cfif isDefined("qResults") AND qResults.recordCount gt 0>
	<!--- output results --->
	<cfoutput query="qResults" maxrows="#maxrows#" startrow="#url.startrow#">
		<div style="margin:0px 30px 10px 0px; font-family: Georgia; font-color: ##666666; font-size: 11px;">
		#score# 
		<!--- check for extFile or farcry object ---> 
		<cfif left(key,2) eq "\\">
			<a href="#application.url.webroot#/download.cfm?extFile=#key#">#qResults.title#</a>
		<cfelse>
			<!--- farcry object --->
			<a href="#application.url.conjurer#?objectid=#key#">#qResults.title#</a>
		</cfif>
		<br />
		#summary#
		</div>
	</cfoutput>
	
	<!--- show previous/next links --->
	<cfoutput>
		<div style="margin:0px,10px,10px,30px;">
		
			<!--- show link to previous x results --->
			<cfif url.startrow gt maxrows>
				<a href="#application.url.conjurer#?objectid=#url.objectid#&criteria=#form.criteria#&startrow=#evaluate(url.startrow-maxrows)#&searchOperator=#form.searchOperator#">&lt;&lt;&lt; Previous #maxrows# results</a>
			<cfelse>
				<span style="color:gray">&lt;&lt;&lt; Previous #maxrows# results</span>
			</cfif>
			
			<!--- spacer --->
			<span style="width:15px;">&nbsp;</span>
			
			<!--- display page numbers --->
			<span>
				<!--- work out number of pages --->
				<cfset pages = ceiling(qResults.recordcount / maxrows)>
				<cfloop from="1" to="#pages#" index="i">
					<cfif i eq 1>
						<cfset link = 1>
					<cfelse>
						<cfset link = evaluate((i-1)*maxrows+1)>
					</cfif>
					<!--- check current page --->
					<cfif link eq url.startrow>
						#i#
					<cfelse>
						<a href="#application.url.conjurer#?objectid=#url.objectid#&criteria=#form.criteria#&startrow=#link#&searchOperator=#form.searchOperator#">#i#</a>
					</cfif>
				</cfloop>
			</span>
			
			<!--- spacer --->
			<span style="width:15px;">&nbsp;</span>
			
			<!--- show link to next x results --->
			<cfif evaluate(url.startrow + maxrows) lt qResults.recordcount>
				<a href="#application.url.conjurer#?objectid=#url.objectid#&criteria=#form.criteria#&startrow=#evaluate(url.startrow+maxrows)#&searchOperator=#form.searchOperator#">Next #maxrows# results &gt;&gt;&gt;</a>
			<cfelse>
				<span style="color:gray">Next #maxrows# results &gt;&gt;&gt;</span>
			</cfif>
			
		</div>
	</cfoutput>
	
<cfelse>
	<cfoutput>
	<div style="margin:0,0,10px,30px;">Your search for "#form.criteria#" produced no results.</div>
	</cfoutput>
</cfif>

<cfsetting enablecfoutputonly="no">