<cfsetting enablecfoutputonly="true">
<!--- @@Copyright: Daemon Pty Limited 2002-2008, http://www.daemon.com.au --->
<!--- @@License:
    This file is part of FarCry.

    FarCry is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FarCry is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with FarCry.  If not, see <http://www.gnu.org/licenses/>.
--->
<!--- import tag libraries --->
<cfimport taglib="/farcry/core/tags/webskin" prefix="skin">
<cfimport taglib="/farcry/core/tags/grid" prefix="grid" />

<!--- params --->
<cfparam name="stParam.layoutClass" default="typeA">
<cfparam name="stParam.pageTitle" default="#stobj.label#">

<cfoutput>
<html lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<cfif structKeyExists(stObj, "extendedMetaData") AND len(trim(stObj.extendedMetaData))><meta name="description" content="#trim(stObj.extendedMetaData)#" /></cfif>
	<cfif structKeyExists(stObj, "metaKeywords") AND len(trim(stObj.metaKeywords))><meta name="keywords" content="#trim(stObj.metaKeywords)#" /></cfif>
	<title>#application.config.general.sitetitle#: #stParam.pageTitle#</title>
	<!-- Framework CSS -->
	<style type="text/css">
		@import url("#application.url.webroot#/css/reset.css");		/* YUI reset */
		@import url("#application.url.webroot#/css/fonts.css");		/* YUI fonts: sets 100% to 13px */
		@import url("#application.url.webroot#/css/grid.css");	 	/* Blueprint grid CSS */	
		@import url("#application.url.webroot#/css/main.css");		/* mollio styles */
	</style>
	<!-- Blueprint IE specific fixes -->
	<!--[if IE]>
		<link rel="stylesheet" href="css/ie.css" type="text/css" media="screen, projection">
	<![endif]-->
	<!-- mollio ie6 and less specific style -->
	<!--[if lte IE 6]>
		<link rel="stylesheet" type="text/css" href="#application.url.webroot#/css/ie6_or_less.css" />
	<![endif]-->
	<script type="text/javascript" src="#application.url.webroot#/js/common.js"></script>
	

</head>
<body>
</cfoutput>

	<grid:container>
		<grid:col id="header" span="24" bLast="true">
		
			<grid:col span="21">
				<grid:col span="15">
					<cfoutput>
						<div id="site-name">#application.config.general.sitetitle#</div>
					</cfoutput>
				</grid:col>
				
				<grid:col span="6" bLast="true">
					<!--- Only shows the search pod if it is available. --->
					<skin:view typename="farVeritySearch" webskin="displayTypeSearchPod" alternateHTML="" />
				</grid:col>
				
			
				<grid:col span="21" bLast="true">
					 <skin:genericNav navID="#application.navid.home#"
						id="nav"
						depth="2"
						bActive="true"
						bIncludeHome="true">
				</grid:col>
			</grid:col>
			

			
			<grid:col span="3" bLast="true">
				<cfoutput>
					<div id="poweredby">
						<a href="http://www.farcrycms.org/">
							<img alt="FarCry - Mollio" src="#application.url.webroot#/wsimages/mollio.gif"/>
						</a>
					</div>
				</cfoutput>
			</grid:col>
			


		
		</grid:col>
	</grid:container>

<cfsetting enablecfoutputonly="false">